import * as React from 'react';

interface ProrankBadgeProps {
  children: React.ReactNode;
  variant?: 'default' | 'primary' | 'success' | 'warning' | 'danger' | 'info' | 'critical' | 'high' | 'medium' | 'low';
  size?: 'small' | 'medium' | 'large';
  className?: string;
}

const ProrankBadge: React.FC<ProrankBadgeProps> = ({
  children,
  variant = 'default',
  size = 'medium',
  className,
}) => {
  const variantClasses = {
    default: 'prorank-badge-default',
    primary: 'prorank-badge-primary',
    success: 'prorank-badge-success',
    warning: 'prorank-badge-warning',
    danger: 'prorank-badge-danger',
    info: 'prorank-badge-info',
    critical: 'prorank-badge-critical',
    high: 'prorank-badge-high',
    medium: 'prorank-badge-medium',
    low: 'prorank-badge-low',
  };

  const sizeClasses = {
    small: 'prorank-badge-sm',
    medium: 'prorank-badge-md',
    large: 'prorank-badge-lg',
  };

  const classes = [
    'prorank-badge',
    variantClasses[variant],
    sizeClasses[size],
    className
  ].filter(Boolean).join(' ');

  return (
    <span className={classes}>
      {children}
    </span>
  );
};

export default ProrankBadge;