import React from 'react';
import { __ } from '@wordpress/i18n';

/**
 * LoadingState Component
 *
 * Unified loading state component for consistent loading UI across all pages
 */
const LoadingState = ({ message = __('Loading…', 'prorank-seo') }) => {
  return (
    <div className="pr-flex pr-items-center pr-justify-center pr-min-h-screen pr-flex-col pr-gap-4">
      <div className="pr-animate-spin pr-rounded-full pr-h-12 pr-w-12 pr-border-b-2 pr-border-primary-500"></div>
      <p className="pr-text-gray-600">{message || __('Loading…', 'prorank-seo')}</p>
    </div>
  );
};

export default LoadingState;
