/**
 * Expert Mode Toggle Component
 *
 * @package
 * @since 0.1.0
 */

import { __ } from '@wordpress/i18n';
import { ToggleControl } from '@wordpress/components';
import { useUserPreferences } from '../hooks/useUserPreferences';

/**
 * Expert Mode Toggle
 *
 * Toggle to enable expert mode for advanced users.
 *
 * @param {Object} props
 * @param {string} props.className
 * @return {JSX.Element} The rendered expert mode toggle component.
 */
const ExpertModeToggle = ({ className = '' }) => {
  const { isExpertMode, toggleExpertMode, saving } = useUserPreferences();

  return (
    <div className={`prorank-expert-mode-toggle ${className}`}>
      <ToggleControl
        label={__('Expert Mode', 'prorank-seo')}
        help={
          isExpertMode === true
            ? __('Advanced settings and options are visible.', 'prorank-seo')
            : __('Enable to show advanced settings and options.', 'prorank-seo')
        }
        checked={isExpertMode === true}
        onChange={toggleExpertMode}
        disabled={saving === true}
      />
    </div>
  );
};

export default ExpertModeToggle;
