import React, { Component } from 'react';
import { __ } from '@wordpress/i18n';

class ErrorBoundary extends Component {
  constructor(props) {
    super(props);
    this.state = { hasError: false, error: null, errorInfo: null };
  }

  static getDerivedStateFromError() {
    return { hasError: true };
  }

  componentDidCatch(error, errorInfo) {
    this.setState({
      error,
      errorInfo,
    });
  }

  render() {
    if (this.state.hasError) {
      return (
        <div
          style={{
            padding: '20px',
            background: '#fee',
            border: '1px solid #fcc',
            borderRadius: '4px',
            margin: '20px',
          }}
        >
          <h2>{__('Something went wrong', 'prorank-seo')}</h2>
          <details style={{ whiteSpace: 'pre-wrap', marginTop: '10px' }}>
            <summary>{__('Error details', 'prorank-seo')}</summary>
            {this.state.error !== null && this.state.error.toString()}
            <br />
            {this.state.errorInfo !== null && this.state.errorInfo.componentStack}
          </details>
        </div>
      );
    }

    return this.props.children;
  }
}

export default ErrorBoundary;
