/**
 * Custom Toggle Component - No checkbox, just a toggle switch
 */
import { useState } from '@wordpress/element';

const CustomToggle = ({ checked, onChange, disabled = false, className = '' }) => {
  const handleClick = () => {
    if (!disabled) {
      onChange(!checked);
    }
  };

  const handleKeyDown = (e) => {
    if (!disabled && (e.key === ' ' || e.key === 'Enter')) {
      e.preventDefault();
      onChange(!checked);
    }
  };

  return (
    <button
      type="button"
      role="switch"
      aria-checked={checked}
      className={`prorank-custom-toggle ${checked ? 'is-checked' : ''} ${disabled ? 'is-disabled' : ''} ${className}`}
      onClick={handleClick}
      onKeyDown={handleKeyDown}
      disabled={disabled}
    >
      <span className="prorank-toggle-track">
        <span className="prorank-toggle-thumb" />
      </span>
    </button>
  );
};

export default CustomToggle;