/**
 * Unified Card Component
 *
 * Replaces ALL old card styles with consistent Tailwind design
 */

const Card = ({ children, className = '', padding = 'md', ...props }) => {
  const paddingClasses = {
    none: '',
    sm: 'pr-p-4',
    md: 'pr-p-6',
    lg: 'pr-p-8',
  };

  return (
    <div
      className={`pr-bg-white pr-rounded-lg pr-shadow-sm pr-border pr-border-gray-200 ${paddingClasses[padding]} ${className}`}
      {...props}
    >
      {children}
    </div>
  );
};

export default Card;
