import { lazy, Suspense } from '@wordpress/element';
import { Spinner } from '@wordpress/components';

// Lazy load the main App component
const App = lazy(() => import(/* webpackMode: "eager" */ './App'));

const LoadingFallback = () => (
  <div
    style={{
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      minHeight: '400px',
      flexDirection: 'column',
      gap: '16px',
    }}
  >
    {/* Use Spinner only if it's defined, otherwise show CSS spinner */}
    {Spinner ? (
      <Spinner />
    ) : (
      <span className="spinner is-active" style={{ float: 'none' }}></span>
    )}
    <p>Loading ProRank SEO...</p>
  </div>
);

const AppWrapper = () => {
  return (
    <Suspense fallback={<LoadingFallback />}>
      <App />
    </Suspense>
  );
};

export default AppWrapper;
