<?php
/**
 * Podcast RSS feed template.
 *
 * @package ProRank\SEO
 */

declare(strict_types=1);

defined('ABSPATH') || exit;

if (!defined('PRORANK_PODCAST_FEED')) {
    define('PRORANK_PODCAST_FEED', true);
}

$prorank_settings = get_option('prorank_seo_podcast', []);
if (!is_array($prorank_settings)) {
    $prorank_settings = [];
}

$prorank_podcast_title = $prorank_settings['podcast_title'] ?? (get_bloginfo('name') . ' Podcast');
$prorank_podcast_subtitle = $prorank_settings['podcast_subtitle'] ?? '';
$prorank_podcast_description = $prorank_settings['podcast_description'] ?? '';
if ($prorank_podcast_description === '') {
    $prorank_podcast_description = $prorank_podcast_subtitle !== '' ? $prorank_podcast_subtitle : get_bloginfo('description');
}
$prorank_podcast_language = $prorank_settings['podcast_language'] ?? str_replace('_', '-', get_locale());
$prorank_podcast_copyright = $prorank_settings['podcast_copyright'] ?? '';

$prorank_feed_url = get_feed_link('podcast');
$prorank_feed_link = home_url('/');

$prorank_limit = isset($prorank_settings['podcast_feed_limit']) ? absint($prorank_settings['podcast_feed_limit']) : 0;
if ($prorank_limit <= 0) {
    $prorank_limit = (int) get_option('posts_per_rss');
}

header('Content-Type: ' . feed_content_type('rss2') . '; charset=' . get_option('blog_charset'), true);

echo '<?xml version="1.0" encoding="' . esc_attr(get_option('blog_charset')) . '"?>';

$prorank_query_args = [
    'post_type' => 'prorank_podcast',
    'post_status' => 'publish',
    'posts_per_page' => $prorank_limit,
    'no_found_rows' => true,
    'ignore_sticky_posts' => true,
];

$prorank_feed_query = new WP_Query($prorank_query_args);
$prorank_original_query = $GLOBALS['wp_query'] ?? null;
$GLOBALS['wp_query'] = $prorank_feed_query;

?>
<rss version="2.0"
    xmlns:content="http://purl.org/rss/1.0/modules/content/"
    xmlns:wfw="http://wellformedweb.org/CommentAPI/"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:atom="http://www.w3.org/2005/Atom"
    xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
    xmlns:slash="http://purl.org/rss/1.0/modules/slash/"
    <?php
    // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core hook.
    do_action('rss2_ns');
    ?>
>
<channel>
    <title><?php echo esc_html($prorank_podcast_title); ?></title>
    <atom:link href="<?php echo esc_url($prorank_feed_url); ?>" rel="self" type="application/rss+xml" />
    <link><?php echo esc_url($prorank_feed_link); ?></link>
    <description><?php echo esc_html($prorank_podcast_description); ?></description>
    <lastBuildDate><?php echo esc_html(mysql2date('r', get_lastpostmodified('GMT'), false)); ?></lastBuildDate>
    <language><?php echo esc_html($prorank_podcast_language); ?></language>
<?php if ($prorank_podcast_copyright !== '') : ?>
    <copyright><?php echo esc_html($prorank_podcast_copyright); ?></copyright>
<?php endif; ?>
<?php
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core hook.
$prorank_update_period = apply_filters('rss_update_period', 'hourly');
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core hook.
$prorank_update_frequency = apply_filters('rss_update_frequency', '1');
?>
    <sy:updatePeriod><?php echo esc_html($prorank_update_period); ?></sy:updatePeriod>
    <sy:updateFrequency><?php echo esc_html($prorank_update_frequency); ?></sy:updateFrequency>
<?php
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core hook.
do_action('rss2_head');
?>

<?php while ($prorank_feed_query->have_posts()) : $prorank_feed_query->the_post(); ?>
    <item>
        <title><?php the_title_rss(); ?></title>
        <link><?php the_permalink_rss(); ?></link>
        <pubDate><?php echo esc_html(get_post_time('r', true)); ?></pubDate>
        <dc:creator><![CDATA[<?php the_author(); ?>]]></dc:creator>
        <guid isPermaLink="false"><?php the_guid(); ?></guid>
<?php if (get_option('rss_use_excerpt')) : ?>
        <description><![CDATA[<?php the_excerpt_rss(); ?>]]></description>
<?php else : ?>
        <description><![CDATA[<?php the_excerpt_rss(); ?>]]></description>
<?php if (strlen(get_the_content())) : ?>
        <content:encoded><![CDATA[<?php the_content_feed('rss2'); ?>]]></content:encoded>
<?php endif; ?>
<?php endif; ?>
        <?php rss_enclosure(); ?>
        <?php
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound -- Core hook.
        do_action('rss2_item');
        ?>
    </item>
<?php endwhile; ?>
</channel>
</rss>
<?php

wp_reset_postdata();
if ($prorank_original_query instanceof WP_Query) {
    $GLOBALS['wp_query'] = $prorank_original_query;
}
