<?php
/**
 * Lazy media helper
 *
 * Adds loading/decoding hints to images/iframes in post content.
 *
 * @package ProRank\SEO\Frontend
 */

declare(strict_types=1);

namespace ProRank\SEO\Frontend;

defined( 'ABSPATH' ) || exit;

class LazyMedia {
    public function init(): void {
        add_filter( 'the_content', [ $this, 'inject_lazy_attrs' ], 15 );
    }

    public function inject_lazy_attrs( string $content ): string {
        if ( is_admin() ) {
            return $content;
        }

        // Add loading/decoding to images
        $content = preg_replace_callback( '#<img[^>]+>#i', function( $matches ) {
            $tag = $matches[0];
            if ( stripos( $tag, 'loading=' ) === false ) {
                $tag = preg_replace( '/<img/i', '<img loading="lazy"', $tag, 1 );
            }
            if ( stripos( $tag, 'decoding=' ) === false ) {
                $tag = preg_replace( '/<img/i', '<img decoding="async"', $tag, 1 );
            }
            return $tag;
        }, $content );

        // Add lazy to iframes
        $content = preg_replace_callback( '#<iframe[^>]+>#i', function( $matches ) {
            $tag = $matches[0];
            if ( stripos( $tag, 'loading=' ) === false ) {
                $tag = preg_replace( '/<iframe/i', '<iframe loading="lazy"', $tag, 1 );
            }
            return $tag;
        }, $content );

        return $content;
    }
}
