<?php
/**
 * Module Slugs Constants
 *
 * Auto-generated for the free plugin build.
 * DO NOT EDIT MANUALLY - regenerate from the build pipeline.
 *
 * @package ProRank\SEO\Core\Constants
 * @since   0.1.0
 */

declare(strict_types=1);

namespace ProRank\SEO\Core\Constants;

defined( 'ABSPATH' ) || exit;

/**
 * Module slugs constants and data
 */
class ModuleSlugs {

    /**
     * Module slug constants
     */
    public const SLUG_DASHBOARD = 'dashboard';
    public const SLUG_ON_PAGE_SEO = 'on-page-seo';
    public const SLUG_TITLES_META = 'titles-meta';
    public const SLUG_BREADCRUMBS = 'breadcrumbs';
    public const SLUG_CONTENT_ANALYSIS = 'content-analysis';
    public const SLUG_SCHEMA_MARKUP = 'schema-markup';
    public const SLUG_INTERNAL_LINKING = 'internal-linking';
    public const SLUG_PERFORMANCE = 'performance';
    public const SLUG_IMAGE_OPTIMIZATION = 'image-optimization';
    public const SLUG_LAZY_LOADING = 'lazy-loading';
    public const SLUG_MINIFICATION = 'minification';
    public const SLUG_TECHNICAL_SEO = 'technical-seo';
    public const SLUG_SITEMAPS = 'sitemaps';
    public const SLUG_REDIRECTS = 'redirects';
    public const SLUG_ROBOTS_TXT = 'robots-txt';
    public const SLUG_SITE_AUDIT = 'site-audit';
    public const SLUG_CRAWL_ERRORS = 'crawl-errors';
    public const SLUG_PERFORMANCE_AUDIT = 'performance-audit';

    /**
     * Module data array
     *
     * @var array<string, array{name: string, tier: string, parent: ?string, description: string, icon_token: string}>
     */
    public const MODULE_DATA = [
        'dashboard' => [
            'name' => 'Dashboard',
            'tier' => 'free',
            'parent' => null,
            'description' => 'SEO overview and insights dashboard',
            'icon_token' => '--pr-icon-dashboard',
        ],
        'on-page-seo' => [
            'name' => 'On-Page SEO',
            'tier' => 'free',
            'parent' => null,
            'description' => 'On-page optimization tools and analysis',
            'icon_token' => '--pr-icon-on-page',
        ],
        'titles-meta' => [
            'name' => 'Titles & Meta',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Manage page titles and meta descriptions',
            'icon_token' => '--pr-icon-titles-meta',
        ],
        'breadcrumbs' => [
            'name' => 'Breadcrumbs',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Navigational breadcrumbs with schema markup',
            'icon_token' => '--pr-icon-breadcrumbs',
        ],
        'content-analysis' => [
            'name' => 'Content Analysis',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Real-time content optimization suggestions',
            'icon_token' => '--pr-icon-content-analysis',
        ],
        'schema-markup' => [
            'name' => 'Schema Markup',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Structured data and rich snippets',
            'icon_token' => '--pr-icon-schema',
        ],
        'internal-linking' => [
            'name' => 'Internal Linking',
            'tier' => 'free',
            'parent' => 'on-page-seo',
            'description' => 'Smart internal link suggestions',
            'icon_token' => '--pr-icon-internal-linking',
        ],
        'performance' => [
            'name' => 'Performance',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Site speed and Core Web Vitals optimization',
            'icon_token' => '--pr-icon-performance',
        ],
        'image-optimization' => [
            'name' => 'Image Optimization',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Optimize images for faster loading',
            'icon_token' => '--pr-icon-image-optimize',
        ],
        'lazy-loading' => [
            'name' => 'Lazy Loading',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Defer loading of off-screen content',
            'icon_token' => '--pr-icon-lazy-load',
        ],
        'minification' => [
            'name' => 'Minification',
            'tier' => 'free',
            'parent' => 'performance',
            'description' => 'Minify CSS, JavaScript, and HTML',
            'icon_token' => '--pr-icon-minify',
        ],
        'technical-seo' => [
            'name' => 'Technical SEO',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Technical optimization and site health',
            'icon_token' => '--pr-icon-technical',
        ],
        'sitemaps' => [
            'name' => 'XML Sitemaps',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Automatic XML sitemap generation',
            'icon_token' => '--pr-icon-sitemap',
        ],
        'redirects' => [
            'name' => 'Redirects',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Manage 301/302 redirects',
            'icon_token' => '--pr-icon-redirects',
        ],
        'robots-txt' => [
            'name' => 'Robots.txt Editor',
            'tier' => 'free',
            'parent' => 'technical-seo',
            'description' => 'Edit robots.txt file',
            'icon_token' => '--pr-icon-robots',
        ],
        'site-audit' => [
            'name' => 'Site Audit & Tools',
            'tier' => 'free',
            'parent' => null,
            'description' => 'Comprehensive site analysis tools',
            'icon_token' => '--pr-icon-site-audit',
        ],
        'crawl-errors' => [
            'name' => 'Crawl Error Detection',
            'tier' => 'free',
            'parent' => 'site-audit',
            'description' => 'Find and fix crawl errors',
            'icon_token' => '--pr-icon-crawl-errors',
        ],
        'performance-audit' => [
            'name' => 'Performance Audit',
            'tier' => 'free',
            'parent' => 'site-audit',
            'description' => 'Core Web Vitals analysis',
            'icon_token' => '--pr-icon-performance-audit',
        ],
    ];

    /**
     * Get all module slugs
     *
     * @return array<int, string>
     */
    public static function all(): array {
        return array_keys(self::MODULE_DATA);
    }
}
