<?php

declare(strict_types=1);

/**
 * Menu Styles Handler
 *
 * @package ProRank\SEO\Admin
 */

namespace ProRank\SEO\Admin;

defined( 'ABSPATH' ) || exit;

/**
 * MenuStyles class
 */
class MenuStyles {

    /**
     * Initialize
     */
    public function init() {
        add_action('admin_enqueue_scripts', [$this, 'enqueue_menu_styles']);
    }

    /**
     * Enqueue menu styles
     */
    public function enqueue_menu_styles() {
        // Admin styles are now bundled with Vite/Tailwind in the JS build
        // Only load legacy CSS if it exists for backwards compatibility
        $css_file = PRORANK_PLUGIN_DIR . 'admin/assets/css/admin.css';
        if (file_exists($css_file)) {
            wp_enqueue_style(
                'prorank-seo-admin',
                PRORANK_PLUGIN_URL . 'admin/assets/css/admin.css',
                [],
                PRORANK_VERSION
            );
        }
    }
}
