<?php
/**
 * Debug Modules - Temporary debug helper
 *
 * @package ProRank\SEO\Admin
 */

declare(strict_types=1);

namespace ProRank\SEO\Admin;

defined( 'ABSPATH' ) || exit;

use ProRank\SEO\Plugin;

/**
 * DebugModules class
 */
class DebugModules {
    
    /**
     * Get module debug info
     *
     * @return array
     */
    public static function get_module_info(): array {
        $plugin = Plugin::get_instance();
        $modules = $plugin->modules();
        $all_modules = $modules->get_modules();
        
        $module_info = [];
        
        foreach ($all_modules as $slug => $module) {
            $module_info[$slug] = [
                'name' => $module->get_name(),
                'enabled' => $modules->is_module_enabled($slug),
                'parent' => $module->get_parent_slug(),
                'tier' => $module->get_feature_tier(),
            ];
        }
        
        return $module_info;
    }
    
    /**
     * Get image/AI related modules
     *
     * @return array
     */
    public static function get_relevant_modules(): array {
        $all_modules = self::get_module_info();
        $relevant = [];
        
        foreach ($all_modules as $slug => $info) {
            if (strpos($slug, 'image') !== false || 
                strpos($slug, 'ai') !== false || 
                strpos(strtolower($info['name']), 'image') !== false ||
                strpos(strtolower($info['name']), 'ai') !== false) {
                $relevant[$slug] = $info;
            }
        }
        
        return $relevant;
    }
}