/**
 * ProRank Link Click Tracker
 * 
 * Tracks clicks on internal links for analytics
 */

(function($) {
    'use strict';
    
    // Only run if we have the required data
    if (typeof prorankLinkTracker === 'undefined') {
        return;
    }
    
    $(document).ready(function() {
        // Track clicks on all internal links
        $('a[href]').on('click', function(e) {
            const $link = $(this);
            const href = $link.attr('href');
            
            // Skip if not a valid link
            if (!href || href === '#' || href.indexOf('javascript:') === 0) {
                return;
            }
            
            // Check if it's an internal link
            const isInternal = isInternalLink(href);
            
            if (isInternal) {
                // Track the click
                trackLinkClick(href);
            }
        });
    });
    
    /**
     * Check if a URL is internal
     */
    function isInternalLink(url) {
        // Handle relative URLs
        if (url.indexOf('/') === 0 || url.indexOf('#') === 0) {
            return true;
        }
        
        // Check if URL starts with site URL
        if (url.indexOf(prorankLinkTracker.siteUrl) === 0) {
            return true;
        }
        
        // Check if it's a relative URL without leading slash
        if (url.indexOf('http://') !== 0 && url.indexOf('https://') !== 0 && url.indexOf('//') !== 0) {
            return true;
        }
        
        return false;
    }
    
    /**
     * Track a link click
     */
    function trackLinkClick(targetUrl) {
        // Convert relative URL to absolute
        if (targetUrl.indexOf('http') !== 0) {
            if (targetUrl.indexOf('/') === 0) {
                targetUrl = prorankLinkTracker.siteUrl + targetUrl;
            } else {
                // Relative URL without leading slash
                const currentPath = window.location.pathname;
                const basePath = currentPath.substring(0, currentPath.lastIndexOf('/'));
                targetUrl = prorankLinkTracker.siteUrl + basePath + '/' + targetUrl;
            }
        }
        
        // Send AJAX request to track the click
        $.ajax({
            url: prorankLinkTracker.ajaxUrl,
            type: 'POST',
            data: {
                action: 'prorank_track_link_click',
                nonce: prorankLinkTracker.nonce,
                source_id: prorankLinkTracker.postId,
                target_url: targetUrl
            },
            // Don't wait for response - let the link navigation continue
            async: true,
            timeout: 1000
        });
    }
    
})(jQuery);